
/*
  CLASSiC DAC, Copyright 2013 SILICON CHIP Publications
  CS4398.c: functions to communicate with and configure the CS4398 DAC IC via SPI
  Written by Nicholas Vinen, 2012-2013
*/

#include "CS4398.h"
#include "Control_SPI.h"
#include "Timer.h"
#include "p33Fxxxx.h"

void CS4398_Setup() {
  LATCbits.LATC14 = 0;
  TRISCbits.TRISC14 = 0;
  Timer_Delay_ms(1);
  LATCbits.LATC14 = 1;

  Timer_Delay_us(100);
  CS4398_Write_Register(CS4398_REG_MISC, CS4398_MISC_CPEN);
  CS4398_Write_Register(CS4398_REG_MUTEC, (CS4398_MUTEC_MUTEP_AUTO<<CS4398_MUTEC_MUTEP_SHIFT)|CS4398_MUTEC_MUTE_A|CS4398_MUTEC_MUTE_B|CS4398_MUTEC_MUTECAB);
}

void CS4398_HoldInReset() {
  LATCbits.LATC14 = 0;
  TRISCbits.TRISC14 = 0;
}

void CS4398_Write_Register(unsigned char addr, unsigned char data) {
  unsigned short cmd = 0x9800 | addr;

  asm volatile("disi #0x3fff");
  LATDbits.LATD1 = 0;
  SPI_Transfer_Word(cmd);
  SPI_Set_Word_Length(8);
  SPI_Transfer_Word(data);
  SPI_Set_Word_Length(16);
  LATDbits.LATD1 = 1;
  asm volatile("disi #0");
}

unsigned char CS4398_Read_Register(unsigned char addr) {
  unsigned short cmd = 0x9800 | addr;
  unsigned char ret;

  asm volatile("disi #0x3fff");
  LATDbits.LATD1 = 0;
  SPI_Transfer_Word(cmd);
  LATDbits.LATD1 = 1;
  Timer_Delay_us(1);
  LATDbits.LATD1 = 0;
  ret = SPI_Transfer_Word(0x9900);
  LATDbits.LATD1 = 1;
  asm volatile("disi #0");
  return ret;
}

void CS4398_Write_Registers(unsigned char addr, const unsigned char* data, unsigned char num) {
  unsigned short cmd = 0x2080 | addr;

  LATDbits.LATD1 = 0;
  SPI_Transfer_Word(cmd);
  while( num > 1 ) {
    SPI_Transfer_Word( (((unsigned short)data[0])<<8) | data[1] );
    data += 2;
    num -= 2;
  }
  if( num ) {
    SPI_Set_Word_Length(8);
    SPI_Transfer_Word(data[0]);
    SPI_Set_Word_Length(16);
  }
  LATDbits.LATD1 = 1;
}

void CS4398_Read_Registers(unsigned char addr, unsigned char* data, unsigned char num) {
  unsigned short cmd = 0x2180 | addr;
  unsigned short temp;

  LATDbits.LATD1 = 0;
  SPI_Transfer_Word(cmd);
  LATDbits.LATD1 = 1;
  Timer_Delay_us(1);
  LATDbits.LATD1 = 0;
  while( num > 1 ) {
    temp = SPI_Transfer_Word(0);
    data[0] = temp>>8;
    data[1] = temp;
    data += 2;
    num -= 2;
  }
  if( num ) {
    SPI_Set_Word_Length(8);
    data[0] = SPI_Transfer_Word(0);
    SPI_Set_Word_Length(16);
  }
  LATDbits.LATD1 = 1;
}

bool CS4398_Verify_ID() {
  return (CS4398_Read_Register(CS4398_REG_CHIP_ID) & 0xF8) == CS4398_CHIP_ID;
}

void CS4398_Set_Volume_and_Balance(unsigned char Volume, signed char Balance) {
  if( Balance >= 0 ) {
    CS4398_Write_Register(CS4398_REG_VOL_LEFT, Volume + Balance);
    CS4398_Write_Register(CS4398_REG_VOL_RIGHT, Volume);
  } else {
    CS4398_Write_Register(CS4398_REG_VOL_LEFT, Volume);
    CS4398_Write_Register(CS4398_REG_VOL_RIGHT, Volume - Balance);
  }
}
